## Introduction

In May 2024, the CMS Collaboration published one of the first physics results from the (early) Run 3 data-taking era of the LHC:

[Search for long-lived particles decaying to final states with a pair of muons in proton-proton collisions at $\sqrt{s}$ = 13.6 TeV](https://link.springer.com/article/10.1007/JHEP05(2024)047).

The search closely follows the Run 2 CMS publication [JHEP05(2023)228](https://link.springer.com/article/10.1007/JHEP05(2023)228), and benefits from trigger improvements resulting in much better sensitivity.

This resource presents the statistical model used for the search, in the form of [COMBINE](https://link.springer.com/article/10.1007/s41781-024-00121-4) datacards; and connects it to material that can be used for reinterpreting the results for untested models.

## Material resources

To go with the publication, we provide:

- [**A results webpage**](https://cms-results.web.cern.ch/cms-results/public-results/publications/EXO-23-014/index.html) with auxiliary material: including trigger and overall efficiencies, comparisons of the final 95% CL constraints with other results, and material for reinterpretation.
- [**HEPData**](https://www.hepdata.net/record/ins2760892): digitised and tabulated paper and auxiliary material plots, including reinterpretation material.

## Datacards

*The `input` directory in the attached tar.gz archive contains a selection of datacards from the search.*

The datacards have been adapted slightly by simplifying the background estimation to enhance clarity and ease reinterpretation.

Datacards corresponding to HAHM and RPV-SUSY signal models, described in the paper, are marked with `HTo2ZdTo2Mu2X` and `SquarkToNeutralinoTo2LNu` in their names, respectively. The numbers in the name encode the signal hypothesis `(mediatorMass_LLPMass_LLPLifetime)` being considered.

Furthermore, since the Run-3 and Run-2 searches were statistically combined in the published result, a combined datacard marked with `2016+2018+2022` is also included.

The search comprises the following categories, and subcategories:

- STA-STA (standalone: muons reconstructed only in the muon system) denoted by STA in the datacards.
- TMS-TMS (tracker + muon system: muons reconstructed both in the tracker and muon system) denoted by TMS in the datacards; this category is further divided into three subcategories, denoted in the datacards by TMS1, TMS2, and TMS3.
- STA-TMS (hybrid; only in the Run-2 part of the combined datacards) denoted by HYB.

In order to ensure numerical stability, the signal rates in all attached datacards are scaled by $10^{-4}$; hence, when extracting upper limits, the results from COMBINE have to be scaled by $10^{-4}$.

## COMBINE setup

General installation instructions for COMBINE can be found in the [COMBINE documentation](https://cms-analysis.github.io/HiggsAnalysis-CombinedLimit/).

A container image is provided to ensure reproducible results. The results in this resource are obtained using v9.2.1:

```bash
docker run --name combine -it gitlab-registry.cern.ch/cms-cloud/combine-standalone:v9.2.1
```

A slim version of the container image is also available at `gitlab-registry.cern.ch/cms-cloud/combine-standalone:v9.2.1-slim`. Versions of packages in the slim container image do not match exactly with the ones in the default container, so small differences in the output of commands with respect to the ones shown below are to be expected.

You can copy files (such as the datacards and other inputs for COMBINE) using `docker cp` as documented [here](https://docs.docker.com/reference/cli/docker/container/cp/).

For the commands below, you may require running `ulimit -s unlimited; ulimit -u unlimited` to avoid memory issues.

## Calculating 95% CL upper limits

In order to use COMBINE to extract 95%CL upper limits for a signal hypothesis, select the corresponding datacard, and run COMBINE with:

```bash
combine datacard_2016+2018+2022_HTo2ZdTo2Mu2X_125_20_ct_1.0_cm.txt -M HybridNew --toysH 5000 --fork 4 --testStat LHC --generateNuisances 0 --generateExternalMeasurements 1 --fitNuisances 1
```

resulting in an output similar to:

```bash
 <<< Combine >>> 
>>> random number generator seed is 123456
>>> using the Profile Likelihood test statistics modified for upper limits (Q_LHC)
>>> method used is HybridNew
/tmp/rstats-FPnEjd
/tmp/rstats-MD8iXr
/tmp/rstats-d2uXAZ
/tmp/rstats-wzYAeJ
/tmp/rstats-KDr0dz
/tmp/rstats-VC2iGd
/tmp/rstats-ngR4IL
/tmp/rstats-SOM7pF
/tmp/rstats-mc7lBT
/tmp/rstats-wo8NaN

 -- Hybrid New -- 
Limit: r < 0.134858 +/- 0.00361171 @ 95% CL
Done in 0.01 min (cpu), 9.76 min (real)
```

Please note that as mentioned earlier, all signal rates in the attached datacards are scaled by $10^{-4}$ for numerical reasons; therefore, the limits from the output as shown above have to be multiplied by $10^{-4}$ to obtain the actual (published) limits on branching ratios (and cross section times branching ratios). Furthermore, since the attached datacards are adapted slightly for clarity and ease of reinterpretation, minor differences of a few percent are expected in the obtained limits when compared to the ones published in the paper.

## Reinterpretation for untested models

The results of the search can be reinterpreted in terms of untested models. To this end, the attached datacards can be modified based on the model and mass hypotheses being considered. We provide the following reinterpretation material for this purpose:

- Three-dimensional efficiency maps that emulate the signal efficiency for the search. These maps are available as Figs. A18 and A19 in the [Run-3 publication HEPData record](https://www.hepdata.net/record/ins2760892), and Figs. A14 - A16 in the [Run-2 publication HEPData record](https://www.hepdata.net/record/ins2083735).
- Observed event and predicted background counts. These numbers are available in Figs. 10, 12, 13 in the [Run-3 publication HEPData record](https://www.hepdata.net/record/ins2760892), and Tables A1 - A5 in the [Run-2 publication HEPData record](https://www.hepdata.net/record/ins2083735).

*Detailed instructions on how to modify the datacards and reinterpret our results in terms of untested models can be found in the [reinterpretation recipe](https://cms-results.web.cern.ch/cms-results/public-results/publications/EXO-23-014/EXO-23-014_reinterpretation_instructions.pdf) and a [RAMP seminar presentation](https://indico.cern.ch/event/1463907/contributions/6163721/attachments/2949025/5183192/RAMPSeminar_CMS-EXO-23-014_IQBAL.pdf).*

