# Introduction

This resource contains the full statistical model from the Higgs Run-1 combination, which led to the Higgs boson discovery, in the format of `Combine` datacards.
The instructions below include a few basic examples on how to extract the significance and signal strength measurements, for more details please consult the [`Combine` documentation](https://cms-analysis.github.io/HiggsAnalysis-CombinedLimit/).

## Datacards

Datacards for the combination (and per-decay channel sub-combinations) leading to the Higgs-boson discovery at CMS are in the `125.5` folder.
The nuisance parameters corresponding to different sources of systematic uncertainties are described in the `*.html` and `*.yml` files located in that folder.

For the full combination of decay channels, the relevant datacard is `125.5/comb.txt`.
The individual datacards for each of the analyses in CMS targeting the main Higgs boson decay modes are also in the `125.5` folder.

## Software instructions

General installation instructions for `Combine` can be found in the [`Combine` documentation](https://cms-analysis.github.io/HiggsAnalysis-CombinedLimit/).

A container image is provided to ensure reproducible results. The results in this README are obtained using `v9.2.1`:

```sh
docker run --name combine -it gitlab-registry.cern.ch/cms-cloud/combine-standalone:v9.2.1
```

A slim version of the container image is also available at `gitlab-registry.cern.ch/cms-cloud/combine-standalone:v9.2.1-slim`.
Versions of packages in the slim container image do not match exactly with the ones in the default container, so small differences in the output of commands with respect to the ones shown below are to be expected.

You can copy files (such as the datacards and other inputs for `combine`) using `docker cp` as documented [here](https://docs.docker.com/reference/cli/docker/container/cp/).

For the commands below, you may require running `ulimit -s unlimited; ulimit -u unlimited` to avoid memory issues.

## Significance Calculation

To calculate the observed significance assuming the mass of the Higgs boson mH=125.5 GeV run,

```bash
combine 125.5/comb.txt --mass 125.5 -M Significance
```

The output will be:

```bash
 <<< Combine >>> 
 <<< v9.2.1 >>>
>>> Random number generator seed is 123456
>>> Method used is Significance

 -- Significance -- 
Significance: 4.87557
Done in 1.76 min (cpu), 1.76 min (real)
```

We can look at partial combinations by using the `combineCards.py` script with the datacards for individual decay channel analyses.
For the observation using only the Higgs to diphoton and Higgs to four-lepton datacards, run

```bash
combineCards.py 125.5/comb_hgg.txt 125.5/comb_hzz.txt > 125.5/comb_hgg_hzz.txt
combine 125.5/comb_hgg_hzz.txt --mass 125.5 -M Significance
```

and the output will be:

```bash
 <<< Combine >>> 
 <<< v9.2.1 >>>
>>> Random number generator seed is 123456
>>> Method used is Significance

 -- Significance -- 
Significance: 4.98442
Done in 0.03 min (cpu), 0.05 min (real)
```

## Signal strength measurements

We can measure the signal strength of the Higgs boson (`r`) and its uncertainty using `Combine`,

```bash
combine 125.5/comb.txt -m 125.5 -M MultiDimFit --algo singles --setParameterRanges r=0.2,1.5
```

and the output will be:

```bash
 <<< Combine >>> 
 <<< v9.2.1 >>>
>>> Random number generator seed is 123456
>>> Method used is MultiDimFit
Set Range of Parameter r To : (0.2,1.5)
Doing initial fit: 

 --- MultiDimFit ---
best fit parameter values and profile-likelihood uncertainties: 
   r :    +0.785   -0.204/+0.218 (68%)
Done in 1.86 min (cpu), 1.86 min (real)
```

In the datacards for the observation, we can also build Physics Models to fit for the signal strength of the different production modes.
We group the signal strengths into those that scale production processes involving couplings between the Higgs boson and vector bosons (`VH`, `qqH`), and those involving couplings between the Higgs boson and fermions (`ggH`, `ttH`, `tH`), yield two signal strengths `RV` and `RF`, respectively. The statistical model is constructed with,

```bash
text2workspace.py -P HiggsAnalysis.CombinedLimit.PhysicsModel:rVrFXSHiggs 125.5/comb.txt -m 125.5 -o comb_RVRF.root
```

and the measured values and uncertainties are obtained with `combine` using,

```bash
combine comb_RVRF.root -m 125.5 -M MultiDimFit --algo singles --setParameterRanges RV=-5,5:RF=-5,5
```

The output will be:

```bash
 <<< Combine >>> 
 <<< v9.2.1 >>>
>>> Random number generator seed is 123456
>>> Method used is MultiDimFit
ModelConfig 'ModelConfig' defines more than one parameter of interest. This is not supported in some statistical methods.
Set Range of Parameter RV To : (-5,5)
Set Range of Parameter RF To : (-5,5)
Doing initial fit: 

 --- MultiDimFit ---
best fit parameter values and profile-likelihood uncertainties: 
   RV :    +0.402   -0.507/+0.539 (68%)
   RF :    +0.920   -0.271/+0.301 (68%)
Done in 2.90 min (cpu), 2.90 min (real)
```

## Higgs Couplings

We can also build a statistical model based on the LO Higgs couplings framework, with parameters of interest `CV` (modifier of the coupling of the Higgs boson to Vector bosons) and `CF` (modifier of the coupling of the Higgs boson to fermions).

```bash
text2workspace.py -P HiggsAnalysis.CombinedLimit.HiggsCouplings_ICHEP12:cVcF 125.5/comb.txt -m 125.5 -o comb_kVkF.root
```

Note that since the discovery, the Physics Model `HiggsCouplings_ICHEP12:cVcF` has evolved to use make use of higher precision theoretical calculations, but for the discovery analysis, this is the model that was used.

We can measure these parameters and their uncertainties with,

```bash
combine comb_kVkF.root -m 125.5 -M MultiDimFit --algo singles
```

and the output will be:

```bash
 <<< Combine >>> 
 <<< v9.2.1 >>>
>>> Random number generator seed is 123456
>>> Method used is MultiDimFit
ModelConfig 'ModelConfig' defines more than one parameter of interest. This is not supported in some statistical methods.
Doing initial fit: 

 --- MultiDimFit ---
best fit parameter values and profile-likelihood uncertainties: 
   CV :    +0.946   -0.120/+0.113 (68%)
   CF :    +0.497   -0.170/+0.203 (68%)
Done in 3.09 min (cpu), 3.09 min (real)
```
